//
//  MCSourceListGenericPaneView.h
//  MCApplication
//
//  Created by Michael Clark on Tue Jul 06 2004.
//  Copyright (c) 2004 __MyCompanyName__. All rights reserved.
//

#import <AppKit/AppKit.h>
#import "MCSourceListAbstractPaneView.h"
#import "MCArrayController.h"

@class MCTVToolbarView;

@interface MCSourceListGenericPaneView : MCSourceListAbstractPaneView  {
	IBOutlet NSOutlineView*       outlineView;
	IBOutlet NSTableView*         tableView;
	IBOutlet NSButton*            addButton;
	IBOutlet NSButton*            deleteButton;
	IBOutlet NSButton*            editButton;
	IBOutlet MCTVToolbarView*     toolbarView;
	IBOutlet MCArrayController*   arrayController;
}

// Utility methods
- (void)processSelectionChange;
- (void)refreshSelectedSourceLists;
// Forces the view to refresh the sourcelists that are being displayed
- (void)refreshSourceListsDisplay;

- (BOOL)canAdd;
- (BOOL)canModify;
- (BOOL)canRemove;

//// Actions
- (IBAction)add: (id)sender;
- (IBAction)modify: (id)sender;
- (IBAction)remove: (id)sender;

- (NSArrayController*)arrayController;

- (void)setupToolbar;
@end
